#ifndef _SQXRUNNER_H_
#define _SQXRUNNER_H_

#include <stdio.h>

#include "SQPCInterface.h"

#if defined(_WIN32) && !defined(__cplusplus)
#define strdup _strdup
#endif

#ifdef __cplusplus
extern "C" {
#endif 

   typedef struct SQXRunnerStruct
   {
      char* mszUSPName;
      SQX_ProjectHandle mszProjID;

      /* Variables that are used if an input file is specified */
      FILE *mInputFile;
      SQX_StringVector mstrVariableNames;
      char *szFileBuffer;
      unsigned int iFileNumCols;
      unsigned int iFileNumRows;


   } SQXRunner;


   int SQXRunner_Init(SQXRunner* pObj, char* szUSPName, char* szPredictionFileName);
   void SQXRunner_Run(SQXRunner* pObj,FILE* pOut, FILE* pErr);
   void SQXRunner_Destroy(SQXRunner* pObj);

   /* Functions that are used if an input file is specified */
   int UmFileReader(SQXRunner* pObj, FILE* pErr);
   int GetQuantitativeData(SQXRunner* pObj, SQX_StringVector *pstrVariableNames, FILE* pErr, SQX_FloatMatrix *pVariableMat);
   int GetQualitativeData(SQXRunner* pObj, SQX_StringVector *pstrVariableNames, FILE* pErr, SQX_StringMatrix *pQualVarMat);
   int GetIndexVectorFromStrings(SQXRunner* pObj, SQX_StringVector *pNames, FILE* pErr, SQX_IntVector *pIndexVector);

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif
